<?php
include 'config.php'; // Include database connection
session_start();

// Check if trader ID is provided
if (!isset($_GET['traderid']) || empty($_GET['traderid'])) {
    header('Location: traders_list.php'); // Redirect if no trader ID is provided
    exit;
}

$traderId = $_GET['traderid'];
$email = $_SESSION['SEshopmail'];

// Fetch trader details
$traderQuery = mysqli_query($con, "SELECT * FROM traders WHERE traderid = '$traderId'");
$trader = mysqli_fetch_assoc($traderQuery);

// Redirect if trader is not found
if (!$trader) {
    header('Location: traders_list.php');
    exit;
}

// Fetch user status
$userQuery = mysqli_query($con, "SELECT trader, social FROM users WHERE email = '$email'");
$userRow = mysqli_fetch_assoc($userQuery);
$copiedTraderId = $userRow['trader'] ?? null;
$isCopied = ($traderId == $copiedTraderId);
$socialStatus = $userRow['social'] ?? 'copy';

// Fetch recent trades
$tradesQuery = mysqli_query($con, "SELECT * FROM trades WHERE traderid = '$traderId' ORDER BY trade_date DESC LIMIT 5");
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Trader Profile</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <style>
        .profile-header {
            background: #f4f1e9;
            padding: 20px;
            border-radius: 10px;
        }

        .profile-img {
            width: 150px;
            height: 150px;
            border-radius: 50%;
            object-fit: cover;
            border: 3px solid #ddd;
        }

        .stats-box {
            text-align: center;
            background: #512eff;
            color: #fff;
            padding: 15px;
            border-radius: 10px;
        }

        .stats-box h5 {
            margin: 0;
            font-size: 20px;
        }

        .stats-box p {
            margin: 0;
            font-size: 14px;
        }
    </style>
</head>

<body>
    <div class="container my-5">
        <div class="profile-header text-center">
            <img src="../admin/imgtrader/<?php echo $trader['image']; ?>" alt="Trader Image" class="profile-img">
            <h3 class="mt-3"><?php echo $trader['tradername']; ?></h3>
            <p><?php echo $trader['bio']; ?></p>
            <form method="POST" id="copyForm" class="d-inline-block mt-3">
                <input type="hidden" name="trader_id" value="<?php echo $traderId; ?>">
                <button type="button" id="copyBtn" class="btn btn-<?php echo $isCopied ? 'danger' : 'success'; ?> btn-sm">
                    <?php echo $isCopied ? 'Copied' : 'Copy'; ?>
                </button>
            </form>
        </div>

        <div class="row my-5">
            <div class="col-md-4">
                <div class="stats-box">
                    <h5><?php echo $trader['followers']; ?></h5>
                    <p>Followers</p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="stats-box">
                    <h5><?php echo $trader['total_trades']; ?></h5>
                    <p>Total Trades</p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="stats-box">
                    <h5><?php echo $trader['success_rate']; ?>%</h5>
                    <p>Success Rate</p>
                </div>
            </div>
        </div>

        <h4>Recent Trades</h4>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Asset</th>
                    <th>Volume</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <?php while ($trade = mysqli_fetch_assoc($tradesQuery)) { ?>
                    <tr>
                        <td><?php echo date('d M Y', strtotime($trade['trade_date'])); ?></td>
                        <td><?php echo $trade['asset']; ?></td>
                        <td><?php echo $trade['volume']; ?></td>
                        <td><?php echo ucfirst($trade['status']); ?></td>
                    </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>

    <script>
        $(document).ready(function () {
            $('#copyBtn').click(function () {
                const button = $(this);
                const traderId = $("input[name='trader_id']").val();
                const action = button.text().trim() === "Copy" ? "copy" : "uncopy";

                $.ajax({
                    url: "copy_trader.php",
                    type: "POST",
                    data: {
                        trader_id: traderId,
                        action: action
                    },
                    success: function (response) {
                        if (response.success) {
                            if (action === "copy") {
                                button.removeClass("btn-success").addClass("btn-danger").text("Copied");
                            } else {
                                button.removeClass("btn-danger").addClass("btn-success").text("Copy");
                            }
                        } else {
                            alert("Something went wrong. Please try again.");
                        }
                    }
                });
            });
        });
    </script>
</body>

</html>
