<?php
// Include database configuration file
include_once("z_db.php");

// Initialize session
session_start();

// Display errors for debugging
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);

// Check if user is logged in
include 'action/check-login.php'; // Assuming this file handles login validation

// Redirect user to logout page if not logged in
if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] == false) {
    header("Location: logout.php");
    exit();
}

// Include database connection file
require('db.php');

// Get user's email address
$SEshopmail = $_SESSION['email']; // Assuming the email address is stored in the session variable 'email'

// Check if form is submitted
if (isset($_POST['assetname'])) {
    // Sanitize input data to prevent SQL injection
    $assetname = mysqli_real_escape_string($con, $_POST['assetname']);
    $assetamount = mysqli_real_escape_string($con, $_POST['assetamount']);
    $t_type = mysqli_real_escape_string($con, $_POST['t_type']);
    $currency = mysqli_real_escape_string($con, $_POST['currency']);
    $email = mysqli_real_escape_string($con, $_POST['email']);
    $date = date('Y-m-d');
    
    // Generate transaction ID
    $transid1 = '#91569767876573gdfjkdsjh57000463891234567890absdfghjhgfdfghjcdeFGHijklMnOpQrsTuVwXYz';
    $transid2 = str_shuffle($transid1);
    $transid = substr($transid2, 0, 8);

    // Fetch user's deposit from the database
    $res = mysqli_query($con, "SELECT deposit FROM users WHERE email = '$SEshopmail'");
    $row = mysqli_fetch_array($res);
    $oldbal = $row['deposit'];

    // Check if user has sufficient funds
    if ($assetamount > $oldbal) {
        $_SESSION['flash_message'] = "<div class='alert alert-danger alert-dismissible alert-alt solid fade show' role='alert'>
                                        <strong>TRADE NOTICE:</strong> Insufficient funds cannot start trade.
                                        
                                      </div>";
        header("Location: wallet.php");
        exit();
    } else {
        // Deduct asset amount from user's balance
        $newbal = $oldbal - $assetamount;
        
        // Insert transaction record into usertrade table
        $res2 = mysqli_query($con, "INSERT INTO usertrade (email,assetname,assetamount, t_type, transid,currency,date) VALUES ('$SEshopmail', '$assetname', '$assetamount','$t_type', '$transid', '$currency','$date')");
        
        // Update user's balance in the users table
        $res3 = mysqli_query($con, "UPDATE users SET deposit='$newbal' WHERE email = '$SEshopmail'");

        // Set success message
        $_SESSION['success_flash'] = "<div class='alert alert-success alert-dismissible alert-alt solid fade show' role='alert'>
                                        <strong>Success:</strong> your trade of  $currency $assetamount on $assetname successful.
                                        <button type='button' class='close' data-dismiss='alert' aria-label='Close'>
                                            <span aria-hidden='true'>×</span>
                                        </button>
                                      </div>";
        // Redirect user to wallet page
        header("Location: wallet.php");
        exit();
    }
}
?>
