<?php 
session_start();

// Check if the user is logged in
if (!isset($_SESSION['email'])) {
    echo "User not logged in.";
    exit;
}

// Database connection
$con = mysqli_connect("localhost", "ewxaqiif_userz", "7YoUCkOhEd3V", "ewxaqiif_dbz");

if (!$con) {
    die("Connection failed: " . mysqli_connect_error());
}

// Fetch session data
$SEshopmail = $_SESSION['email'];

// Fetch user details from the database
$query = mysqli_query($con, "SELECT * FROM users WHERE email = '$SEshopmail'");
$user = mysqli_fetch_array($query);

// Check if user data exists
if (!$user) {
    echo "User not found.";
    exit;
}

// Fetch account type (ensure this is in the database)
$accounttype = $user['accounttype']; 

// Close the database connection
mysqli_close($con);

// QR Code Generation: Balance to QR code (using an external library or service)
$balance = $user['balance']; // Assuming 'balance' is a column in the users table

// Check if uploads folder exists, create if not
$uploadDir = 'uploads';
if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0755, true);
}

$barcodeImage = $uploadDir . '/barcode.png'; // Assuming barcode will be uploaded as 'barcode.png'
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User ID Card</title>
    <link rel="icon" href="https://zetrea.com/files/logo.png" type="image/png">
    <script src="https://cdn.jsdelivr.net/npm/qrcode"></script> <!-- QR Code Library -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css">
    <style>
        body {
            background-color: #2c2c2c;
            color: #fff;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
            flex-direction: column;
        }
        .id-card-wrapper {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            align-items: center;
            gap: 20px;
        }
        .id-card {
            width: 220px;
            height: 360px;
            border: 1px solid #af8f4c;
            border-radius: 10px;
            overflow: hidden;
            position: relative;
            background-color: #333;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.5);
            margin: 10px;
        }
        .id-card .overlay {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-image: url('https://img.freepik.com/premium-vector/blue-fluid-wave-duotone-geometric-compositions-with-gradient-3d-flow-shape-innovation-mode-vector_773275-750.jpg');
            background-size: cover;
            background-position: center;
            opacity: 0.3;
        }
        .id-card .content {
            position: relative;
            z-index: 1;
            text-align: center;
        }
        .id-card .header {
            background-color: #13284ecc;
            color: #fff;
            text-align: center;
            padding: 10px;
            font-size: 18px;
            font-weight: bold;
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 10px;
        }
        .id-card .header .logo {
            width: 40px;
            display: inline-block;
        }
        .id-card .user-image {
            width: 100px;
            height: 100px; /* Rectangle image with curved edges */
            border-radius: 15px; /* Curved edges */
            margin: 10px auto;
            display: block;
            border: 3px solid #fff;
        }
        .id-card .details {
            text-align: center;
            margin-top: 10px;
            padding: 10px;
        }
        .id-card .details p {
            margin: 5px 0;
            font-size: 14px;
            font-weight: bold;
        }
        .id-card .details i {
            margin-right: 5px;
            color: #add8e6; /* Light blue color */
        }
        .id-card .qr-code {
            width: 100px;
            margin: 10px auto;
            display: block;
        }
        .company-name {
            position: absolute;
            top: 10px;
            left: 10px;
            font-size: 24px;
            font-weight: bold;
            color: #af8f4c;
            text-shadow: 0 0 5px #000;
        }
        .barcode {
            width: 100%;
            margin-top: 20px;
            text-align: center;
        }
        .terms {
            text-align: left;
            padding: 10px;
        }
    </style>
</head>
<body>
    
    
      <!-- Close Button with FontAwesome Icon -->
    <a href="portfolio.php" style="position: fixed; top: 10px; left: 10px; font-size: 30px; color: red; background-color: white; border: 2px solid red; padding: 10px 15px; text-decoration: none; border-radius: 50%; box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);">
        <i class="fa fa-window-close" aria-hidden="true"></i>
    </a>

    <!-- Print Button -->
    <button onclick="window.print()" style="position: fixed; top: 10px; right: 10px; font-size: 16px; color: white; background-color: #74c947; border: none; padding: 10px 20px; cursor: pointer;">Print</button>




    <div class="id-card-wrapper">
        <!-- Front Side -->
        <div class="id-card">
            <div class="overlay"></div>
            <div class="content">
                <div class="header">
                    <img src="https://zetrea.com/files/logo.png" alt="zetrea.com TRADER Logo" class="logo">
                    zetrea.com TRADER
                </div>
                <img src="<?php echo 'uploads/' . $user['image']; ?>" alt="User Image" class="user-image">
                <div class="details">
                    <p><i class="fas fa-user"></i><?php echo $user['firstname'] . ' ' . $user['lastname']; ?></p>
                    <p><i class="fas fa-envelope"></i><?php echo $user['email']; ?></p>
                    <p><i class="fas fa-flag"></i><?php echo $user['country']; ?></p>
                    <p><i class="fas fa-id-card"></i><?php echo $user['userid']; ?></p>
                    <p><i class="fas fa-venus-mars"></i><?php echo $user['gender']; ?></p>
                    <p><i class="fas fa-coins"></i><?php echo $user['currency']; ?></p>
                    
                    <link href="https://fonts.googleapis.com/css2?family=Dancing+Script:wght@400;700&display=swap" rel="stylesheet">
                    <style>
                        .signature {
                            font-family: 'Dancing Script', cursive;
                            font-size: 10px;
                            color: #ffff;
                            letter-spacing: 2px;
                            font-weight: 10;
                            display: inline-block;
                            transform: rotate(-3deg);
                            position: relative;
                        }
                        .signature::after {
                            content: "";
                            position: absolute;
                            bottom: -10px;
                            left: 0;
                            right: 0;
                            border-bottom: 2px solid #2c3e5000;
                            transform: scaleX(1.1);
                        }
                    </style>
                   
                </div><button class="styled-button" 
    style="background-color: #13284ecc; color: white; border: 2px solid #0f1c5f; padding: 15px 30px; font-size: 16px; cursor: pointer; border-radius: 5px; position: relative; overflow: hidden; box-shadow: 0 4px 6px rgba(0, 0, 0, 0.2); transition: all 0.3s ease; text-transform: uppercase; font-weight: bold; letter-spacing: 2px;">
    Original Stamp
    <span style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; background: radial-gradient(circle, rgba(255, 255, 255, 0.4) 10%, transparent 60%); opacity: 0; animation: flare 1.5s infinite;"></span>
</button>

<style>
    @keyframes flare {
        0% {
            transform: scale(0);
            opacity: 0.5;
        }
        50% {
            transform: scale(1.2);
            opacity: 0;
        }
        100% {
            transform: scale(0);
            opacity: 0.5;
        }
    }
</style>


            </div>
        </div>

        <!-- Back Side -->
        <div class="id-card">
            <div class="overlay"></div>
            <div class="content">
                <div class="header">zetrea.com TRADER</div>
                
                <div class="qr-code" id="qr-code"></div>
                
                <div class="details">
                    <p><i class="fas fa-wallet"></i> LEVEL: <?php echo $accounttype; ?> <?php echo $user['accounttype']; ?></p>
                    <div class="terms">
                        <small>
                            This card is the property of zetrea.com TRADER.<br>
                            Unauthorized use or alteration is prohibited.<br>
                            Contact support at support@zetrea.com.online for assistance.
                        </small>
                    </div>
                    <p><i class="fas fa-calendar"></i> VALID UNTIL: <?php echo date('F Y', strtotime('+1 year')); ?></p>
                </div>
                
                 <div class="signature">
                        zetrea.comLimited
                    </div>

                <div class="barcode">
                    <img src="https://www.color-hex.com/palettes/40741.png" alt="SW" style="width: 100%; border-radius: 5px;">
                </div>
            </div>
        </div>

    </div>
    <button class="styled-button" 
    style="background-color: #512eff; color: white; border: none; padding: 15px 30px; font-size: 16px; cursor: pointer; border-radius: 5px; position: relative; overflow: hidden; box-shadow: 0 4px 6px rgba(0, 0, 0, 0.2); transition: all 0.3s ease;"
    onclick="window.location.href='deposit.php';">
    Activate Card
    <span style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; background: radial-gradient(circle, rgba(255, 255, 255, 0.4) 10%, transparent 60%); opacity: 0; animation: flare 1.5s infinite;"></span>
</button>

<style>
    @keyframes flare {
        0% {
            transform: scale(0);
            opacity: 0.5;
        }
        50% {
            transform: scale(1.2);
            opacity: 0;
        }
        100% {
            transform: scale(0);
            opacity: 0.5;
        }
    }
</style>


</body>
</html>  
