<?php
// Start the session and include required files
session_start();
include_once("z_db.php");
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);

// Include login check
include 'action/check-login.php';

// Redirect if not logged in
if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] == false) {
    echo "<script language='javascript'>window.location = 'logout.php';</script>";
    exit();
}

require('db.php');

// Check if email is set in session
if (isset($_SESSION['email'])) {
    $SEshopmail = $_SESSION['email'];
    $query = "SELECT * FROM `users` WHERE email='$SEshopmail'";
    $result = mysqli_query($con, $query) or die(mysqli_error($con));

    if (mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        $upgrade = $row['upgrade'];
        $image = $row['image'];

        // Redirect if image is not empty
        if (!empty($image)) {
            header("Location: idcc.php");
            exit();
        }
    }
}

// Process the ID Card form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['copy'])) {
        $SEshopmail = $_SESSION['email'];
        $trader_id = mysqli_real_escape_string($con, $_POST['trader_id']);
        $trader_name = mysqli_real_escape_string($con, $_POST['trader_name']);

        $update = mysqli_query($con, "UPDATE users SET trader = '$trader_id' WHERE email = '$SEshopmail'");

        // Adding the alert notification when the update is successful
        if ($update) {
            $_SESSION['notification_message'] = 'Trader ID updated successfully!';
            $_SESSION['notification_color'] = 'green';
        } else {
            $_SESSION['notification_message'] = 'Error updating Trader ID. Please try again.';
            $_SESSION['notification_color'] = 'red';
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ID Card Form</title>
    <link rel="icon" href="https://Hexabitcraft.com/files/logo.png" type="image/png">
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            background-color: #1e1e2f;
            color: #f5f5f5;
        }

        .header {
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 10px;
            background-color: #252539;
        }

        .header img {
            max-height: 60px;
            margin-right: 15px;
        }

        .header h1 {
            font-size: 24px;
            color: #ffffff;
            margin: 0;
        }

        .form-container {
            max-width: 500px;
            margin: 20px auto;
            background: #2a2a3d;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.5);
        }

        .form-container h2 {
            text-align: center;
            margin-bottom: 20px;
            color: #ffffff;
        }

        label {
            font-size: 14px;
            color: #cccccc;
        }

        input[type="file"],
        input[type="text"],
        input[type="submit"],
        input[type="email"] {
            width: 100%;
            padding: 10px;
            margin: 10px 0;
            border-radius: 5px;
            border: 1px solid #444;
            background: #1e1e2f;
            color: #f5f5f5;
        }

        input[type="submit"] {
            background: #4caf50;
            border: none;
            cursor: pointer;
        }

        input[type="submit"]:hover {
            background: #45a049;
        }

        .readonly {
            background: none;
            border: none;
            color: #74c947;
            font-weight: bold;
        }

        .notification {
            padding: 10px;
            margin-bottom: 20px;
            text-align: center;
        }

        .green {
            background-color: #28a745;
            color: #fff;
        }

        .red {
            background-color: #dc3545;
            color: #fff;
        }
    </style>
</head>

<body>
    <div class="header">
        <img src="https://Hexabitcraft.com/files/logo.png" alt="Hexabitcraft">
        <h1>Hexabitcraft</h1>
    </div>

    <div class="form-container">
        <h2>ID Card Generator</h2>

        <!-- Display notification if it exists -->
        <?php if (isset($_SESSION['notification_message'])): ?>
            <div class="notification <?php echo $_SESSION['notification_color']; ?>">
                <?php
                echo $_SESSION['notification_message'];
                // Clear the notification
                unset($_SESSION['notification_message']);
                unset($_SESSION['notification_color']);
                ?>
            </div>
        <?php endif; ?>

        <form action="idcard.php" method="POST" enctype="multipart/form-data">
            <label for="special_number">Special Number:</label>
            <input type="text" id="special_number" name="special_number" required>

            <label for="image">Upload Picture:</label>
            <input type="file" id="image" name="image" accept=".png,.jpg,.jpeg,.webp,.svg" required>

            <input type="hidden" name="bonus" value="0">

          <label for="email">Email:</label>
<input type="email" id="email" name="email" value="<?php echo htmlspecialchars($SEshopmail); ?>" readonly class="readonly" required style="color: #74c947; background-color: transparent; opacity: 7; border: none;">

<input type="submit" value="Generate ID Card" style="background-color: yellow; color: black; border: none; padding: 10px 20px; cursor: pointer;">

        </form>
    </div>
</body>

</html>
