  <?php
// Include database connection
include_once("z_db.php");
session_start();
error_reporting(0);
include 'action/check-login.php';

// Ensure user is logged in
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    echo "<script>window.location = 'logout.php';</script>";
    exit();
}

$SEshopmail = $_SESSION['email'] ?? '';

// Check for verification status
require('db.php');
if ($SEshopmail) {
    $query = "SELECT * FROM `users` WHERE email='$SEshopmail' AND (status ='verified' OR status ='underreview')";
    $result = mysqli_query($con, $query) or die(mysqli_error($con));

    if (mysqli_num_rows($result) > 0) {
        echo "<script>window.location.href='verification.php';</script>";
        exit();
    }
}

// Handle follow/unfollow actions
if (isset($_POST['action'])) {
    $trader_id = mysqli_real_escape_string($con, $_POST['trader_id']);
    $trader_name = mysqli_real_escape_string($con, $_POST['trader_name']);
    $action = $_POST['action'];

    if ($action == 'follow') {
        // Update the trader ID for the user when following
        $update = mysqli_query($con, "UPDATE users SET trader = '$trader_id' WHERE email = '$SEshopmail'");

        if ($update) {
            echo "<script>alert('You are now following $trader_name');</script>";
        } else {
            echo "<script>alert('Failed to follow $trader_name');</script>";
        }
    } elseif ($action == 'unfollow') {
        // Remove the trader ID for the user when unfollowing
        $update = mysqli_query($con, "UPDATE users SET trader = NULL WHERE email = '$SEshopmail'");

        if ($update) {
            echo "<script>alert('You have unfollowed $trader_name');</script>";
        } else {
            echo "<script>alert('Failed to unfollow $trader_name');</script>";
        }
    }
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Copy Trader</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css">
    <style>
        body {
            background-color: #1a1a1a;
            color: #e5e5e5;
        }
        .trader-card {
            background-color: #2c2c2c;
            border: 1px solid #74c947;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 20px;
            transition: transform 0.3s ease;
        }
        .trader-card:hover {
            transform: scale(1.05);
        }
        .btn-follow {
            background-color: #74c947;
            color: white;
            width: 100%;
        }
        .btn-follow:hover {
            background-color: #5ca036;
        }
        .trader-image {
            border-radius: 5px;
            width: 100%;
            max-height: 200px;
            object-fit: cover;
        }
        .logo {
            width: 150px;
            display: block;
            margin: 20px auto;
        }
    </style>
</head><body>
    <div class="container my-5">
        <img src="https://Hexabitcraft.com/logo.svg" alt="Site Logo" class="logo" style="width: 50px; height: auto;">
        <h4 class="text-center">Copy Trader</h4>

        <div class="row">
            <?php
            // Check if the form is submitted
            if ($_SERVER['REQUEST_METHOD'] === 'POST') {
                $traderId = $_POST['trader_id'];
                $action = $_POST['action'];

                $socialValue = ($action === 'copy') ? 'copied' : 'copy';

                $updateQuery = "UPDATE users SET social = '$socialValue', trader = '$traderId' WHERE email='$SEshopmail'";
                mysqli_query($con, $updateQuery);

                header('Location: ' . $_SERVER['PHP_SELF']);
                exit;
            }

            // Fetch traders from the database
            $ret = mysqli_query($con, "SELECT * FROM traders");
            while ($row = mysqli_fetch_array($ret)) {
                $currentTraderId = $row['traderid'];
                $userQuery = mysqli_query($con, "SELECT trader, social FROM users WHERE email='$SEshopmail'");
                $userRow = mysqli_fetch_assoc($userQuery);
                $copiedTraderId = $userRow['trader'] ?? null;
                $isCopied = ($currentTraderId == $copiedTraderId);
                $socialStatus = $userRow['social'] ?? 'copy';
            ?>
                <div class="col-md-4 col-lg-3 mb-4">
                    <!-- Wrap the card inside a link -->
                    <a href="home.php?traderid=<?php echo $currentTraderId; ?>" class="card-link" style="text-decoration: none; color: inherit;">
                        <div class="card" style="position: relative; border: 1px solid #ddd; border-radius: 15px; overflow: hidden;">
                            <img src="../admin/imgtrader/<?php echo $row['image']; ?>" alt="Trader Image" class="card-img-top" style="width: 100%; height: 200px; object-fit: cover;">
                            <!-- Overlay text -->
                            <div class="overlay-text" style="position: absolute; top: 10px; left: 10px; color: white; background: rgba(0, 0, 0, 0.5); padding: 5px 10px; border-radius: 5px;">
                                <h5 style="margin: 0;"><?php echo $row['tradername']; ?></h5>
                                <p style="margin: 0; font-size: 14px;"><?php echo $row['traderid']; ?></p>
                            </div>
                        </div>
                    </a>

                    <!-- Copy/Copied Button -->
                    <form method="POST" action="" class="text-center">
                        <input type="hidden" name="trader_id" value="<?php echo $currentTraderId; ?>">
                        <input type="hidden" name="trader_name" value="<?php echo $row['tradername']; ?>">
                        <input type="hidden" name="action" value="<?php echo $isCopied ? 'uncopy' : 'copy'; ?>">
                        <button type="submit" class="btn btn-<?php echo $isCopied ? 'danger' : 'success'; ?> btn-sm w-100 mt-3" style="border-radius: 25px;">
                            <?php echo $isCopied ? 'Copied' : 'Copy'; ?>
                        </button>
                    </form>
                </div>
            <?php } ?>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/js/bootstrap.bundle.min.js"></script>
</body>


</html>
