<?php
// Connect to the database
$con = mysqli_connect("localhost", "ewxaqiif_userz", "7YoUCkOhEd3V", "ewxaqiif_dbz");
if (!$con) { die("Connection failed: " . mysqli_connect_error()); }

$invoiceId = isset($_GET['id']) ? $_GET['id'] : '';
if ($invoiceId == '') { echo "No invoice ID provided."; exit; }

$query = "SELECT * FROM deposit WHERE transid = '$invoiceId'";
$result = mysqli_query($con, $query);
if (!$result || mysqli_num_rows($result) == 0) { echo "No invoice found for this ID."; exit; }
$row = mysqli_fetch_assoc($result);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice Details - <?php echo $row['transid']; ?></title>
    <link rel="icon" href="https://zetrea.com/files/logo.png" type="image/x-icon">
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <style>
        .black-bg { background-color: #000; }
        .white-text { color: #fff; }
        .status-unpaid { color: red; }
        .status-paid { color: green; }
        .status-processing { color: blue; }
    </style>
</head>
<body class="bg-black text-white font-sans">
    <div class="container mx-auto p-6">
        <div class="flex justify-between items-center mb-8">
            <img src="https://zetrea.com/files/logo.png" alt="Company Logo" class="w-16">
            <div class="text-right">
                <h1 class="text-3xl font-bold">INVOICE</h1>
                <p class="text-lg">Transaction ID: <?php echo $row['transid']; ?></p>
            </div>
        </div>
        <div class="mb-8">
            <table class="min-w-full bg-black text-white">
                <thead>
                    <tr>
                        <th class="py-2 px-4 bg-gray-800">Details</th>
                        <th class="py-2 px-4 bg-gray-800">Information</th>
                    </tr>
                </thead>
                <tbody>
                    <tr class="bg-gray-900">
                        <td class="py-2 px-4">Plan</td>
                        <td class="py-2 px-4"><?php echo $row['plan']; ?></td>
                    </tr>
                    <tr>
                        <td class="py-2 px-4">Email</td>
                        <td class="py-2 px-4"><?php echo $row['userid']; ?></td>
                    </tr>
                    <tr class="bg-gray-900">
                        <td class="py-2 px-4">Amount</td>
                        <td class="py-2 px-4">$<?php echo $row['amount']; ?></td>
                    </tr>
                    <tr>
                        <td class="py-2 px-4">Date</td>
                        <td class="py-2 px-4"><?php echo $row['date']; ?></td>
                    </tr>
                    <tr class="bg-gray-900">
                        <td class="py-2 px-4">Status</td>
                        <td class="py-2 px-4 <?php echo 'status-' . strtolower($row['status']); ?>"><?php echo ucfirst($row['status']); ?></td>
                    </tr>
                    <tr>
                        <td class="py-2 px-4">Wallet Address</td>
                        <td class="py-2 px-4"><?php echo $row['selectedaddress']; ?></td>
                    </tr>
                    <tr class="bg-gray-900">
                        <td class="py-2 px-4">Deposit Method</td>
                        <td class="py-2 px-4"><?php echo $row['depositmethod']; ?></td>
                    </tr>
                    <tr>
                        <td class="py-2 px-4">Currency</td>
                        <td class="py-2 px-4">
                     
                            $
                        </td>
                    </tr>
                    <tr class="bg-gray-900">
                        <td class="py-2 px-4">Narrative</td>
                        <td class="py-2 px-4"><?php echo $row['narrat']; ?></td>
                    </tr>
                </tbody>
            </table>
        </div>
        <div class="text-right mb-8">
            <p class="text-lg">Subtotal: $<?php echo $row['amount']; ?></p>
            <p class="text-xl font-bold">Grand Total: $<?php echo $row['amount']; ?></p>
        </div>
        <div class="text-center mt-8">
            <a href="javascript:history.back()" class="inline-block px-6 py-2 bg-gray-800 text-white rounded-lg hover:bg-gray-700">Back to Invoices</a>
            <button class="inline-block px-6 py-2 bg-gray-800 text-white rounded-lg hover:bg-gray-700" onclick="window.print()">Print Invoice</button>
            <button class="inline-block px-6 py-2 bg-gray-800 text-white rounded-lg hover:bg-gray-700" onclick="downloadPDF()">Download Invoice as PDF</button>
        </div>
    </div>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.9.2/html2pdf.bundle.min.js"></script>
    <script>
        function downloadPDF() {
            var element = document.getElementById('invoice');
            var opt = { margin: 0.5, filename: 'invoice_<?php echo $row['transid']; ?>.pdf', image: { type: 'jpeg', quality: 0.98 }, html2canvas: { scale: 2 }, jsPDF: { unit: 'in', format: 'letter', orientation: 'portrait' } };
            html2pdf().from(element).set(opt).save();
        }
    </script>
</body>
</html>

<?php mysqli_close($con); ?>
